//
//  CMS_Users.swift
//  Composr Mobile SDK
//
//  Created by Aaswini on 04/08/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
/*
 
 CMS_Users
 
 bool has_page_access(page) - works using data retrieved when logging in
 bool has_privilege(string privilegeName) - works using data retrieved when logging in
 bool has_zone_access(string zoneName) - works using data retrieved when logging in
 bool is_staff() - works using data retrieved when logging in
 bool is_super_admin() - works using data retrieved when logging in
 int get_member() - works using data retrieved when logging in
 int get_session_id() - works using data retrieved when logging in
 string get_username() - works using data retrieved when logging in
 array get_members_groups() - works using data retrieved when logging in
 array get_members_groups_names() - works using data retrieved when logging in
 string get_value - gets a member setting (lots of these stored when logging in, using standard ad-hoc preferences mechanism)

 */

import UIKit
import Foundation

class CMS_Users: NSObject {
    
    /**
     *  Returns if the user has page access
     *
     *  @param page Name of page to check for
     *
     *  @return YES if has page access, NO if not
     */
    class func has_page_access(page: String) -> Bool {
        var defaults = NSUserDefaults.standardUserDefaults()
        if defaults.objectForKey(k_User_PagesBlacklist)! {
            var blackListedPages = defaults.objectForKey(k_User_PagesBlacklist)!
            for blackListedPage: String in blackListedPages {
                if (blackListedPage == page) {
                    return false
                }
            }
        }
        return true
    }
    
    /**
     *  Returns if the user has a particular privilage
     *
     *  @param privilegeName Name of the privilage
     *
     *  @return YES if has privilage, NO if not
     */
    class func has_privilege(privilegeName: String) -> Bool {
        var defaults = NSUserDefaults.standardUserDefaults()
        if defaults.objectForKey(k_User_Privileges)! {
            var userPrivilages = defaults.objectForKey(k_User_Privileges)!
            if userPrivilages.contains(privilegeName) {
                return true
            }
        }
        return false
    }
    
    /**
     *  Returns if a user has access to a particular zone
     *
     *  @param zoneName Name of the zone
     *
     *  @return YES if has zone access, NO if not
     */
    class func has_zone_access(zoneName: String) -> Bool {
        var defaults = NSUserDefaults.standardUserDefaults()
        if defaults.objectForKey(k_User_Zones)! {
            var userZones = defaults.objectForKey(k_User_Zones)!
            if userZones.contains(zoneName) {
                return true
            }
        }
        return false
    }
    
    /**
     *  Returns if a user is staff or not
     *
     *  @return YES if user is staff, NO if not
     */
    class func is_staff() -> Bool {
        var defaults = NSUserDefaults.standardUserDefaults()
        if defaults.objectForKey(k_isStaff)! {
            return CBool(defaults.objectForKey(k_isStaff)!)
        }
        return false
    }
    
    /**
     *  Returns if the user is a super admin or not ( Returns NO if user is staff )
     *
     *  @return YES if user is super admin, NO if not
     */
    class func is_super_admin() -> Bool {
        var defaults = NSUserDefaults.standardUserDefaults()
        if defaults.objectForKey(k_isSuperAdmin)! {
            return !CMS_Users.is_staff()
        }
        return false
    }
    
    /**
     *  Returns the member id of the user retrieved from login data
     *
     *  @return member id of the user
     */
    class func get_member() -> Int {
        var defaults = NSUserDefaults.standardUserDefaults()
        if defaults.objectForKey(k_MemberID)! {
            return CInt(defaults.objectForKey(k_MemberID)!)
        }
        return -1
    }
    
    /**
     *  Returns the session id of the user retrieved from login data
     *
     *  @return session id of the user
     */
    class func get_session_id() -> Int {
        var defaults = NSUserDefaults.standardUserDefaults()
        if defaults.objectForKey(k_SessionID)! {
            return CInt(defaults.objectForKey(k_SessionID)!)
        }
        return -1
    }
    
    /**
     *  Returns the username of the user
     *
     *  @return username of the user
     */
    class func get_username() -> String {
        var defaults = NSUserDefaults.standardUserDefaults()
        if defaults.objectForKey(k_Username)! {
            return defaults.objectForKey(k_Username)!
        }
        return ""
    }
    
    /**
     *  Returns all the member groups retreived from the login data
     *
     *  @return Array of member groups
     */
    class func get_members_groups() -> [AnyObject] {
        var defaults = NSUserDefaults.standardUserDefaults()
        if defaults.objectForKey(k_Members_Groups)! {
            return defaults.objectForKey(k_Members_Groups)!
        }
        return []
    }
    
    /**
     *  Returns only names of the member groups retreived from the login data
     *
     *  @return Array of member group names
     */
    class func get_members_groups_names() -> [AnyObject] {
        return CMS_Arrays.collapse_1d_complexity("name", CMS_Users.get_members_groups())
    }
    
    /**
     *  Returns value for the key from user defaults
     *
     *  @param key Key
     *
     *  @return String Value for the key. @"" if nil.
     */
    class func get_value(key: String) -> String {
        var defaults = NSUserDefaults.standardUserDefaults()
        if defaults.objectForKey(key)! {
            return defaults.objectForKey(key)!
        }
        return ""
    }
    
    /**
     *  Returns password of user saved in user defaults
     *
     *  @return Password of the user
     */
    class func get_password() -> String {
        var defaults = NSUserDefaults.standardUserDefaults()
        if defaults.objectForKey(k_Password)! {
            return defaults.objectForKey(k_Password)!
        }
        return ""
    }
}